#pragma once
#include "dllmanager.h"
#include "ConfigSTY.h"
#include "ConfigPOW.h"
#include "ConfigCFG.h"
#include "ConfigSPC.h"
#include "ConfigSIM.h"
#include "ConfigPHB.h"
////////////////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
////////////////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API C0707DllManager :	public CDllManager
{
public:
	C0707DllManager(void);
	~C0707DllManager(void);
	virtual void	InitService();
	virtual CString GetIdentification();
	
	virtual UInt8	GetCREG();
	virtual int		GetCPIN();
	virtual UInt8	GetCFUN();
	virtual UInt8	GetCMEE();

	virtual UInt8	GetPhonePower();
	virtual void	SetPhonePower(UInt8 iPower);
	virtual UInt8	GetPhoneFunctionality();
	virtual void	SetPhoneFunctionality(UInt8 iFun);
	virtual UInt8	GetNwkRegistration();
	virtual void	SetNwkRegistration(UInt8 iState);
	virtual void	SetPhoneInReadyState();
	virtual void	SetPhoneInPIN1State();
	virtual void	SetPhoneInPIN2State();
	virtual void	SetPhoneInPUK1State();
	virtual void	SetPhoneInPUK2State();
	virtual Bool	IsSIMInserted();

	virtual void	SetMuxStatus(UInt8 iStatus);

	virtual	void	LoadConfig(Bool iBroadcast);
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
